library(scales)
inputDirectory = '/Users/gfivash/Dropbox/Greg/Work/PhD/Thesis Chapters/Chapter 3 - Sediment hummocks/Data Chapter 3 submission/Figure 3 - growth exp 1/'
setwd(inputDirectory)

d = read.csv('Individual-specific harvest.csv')
d$biomass.g = exp(-4.60303)*(d$area.cm2^1.15896)
d$biomass.mg = d$biomass.g*1000

d$pot.ID = factor(d$pot.ID)
d$harvest_date = as.POSIXct(d$harvest_date)
d$lense = factor(d$lense, levels = c('hollow', 'flat', 'hummock'))
d$inundation.percent = factor(d$inundation.percent, levels = c('50','35','20'))
d$drainage = factor(d$drainage, levels = c('no drainage', 'drainage'))

# --- Figure 1 ---- #

# plotDirectory = '/Users/gfivash/Desktop/'
# setwd(plotDirectory)
# tiff("Figure 3.tif",
#      width = 7, height = 6, 
#      units = 'in', res = 300)

par(mfrow = c(2,2))
filter = d$drainage == 'no drainage'
hist((d$biomass.g[d$lense == 'hollow' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16), 
     col = alpha('yellow',0.5), lty = 0, freq = F,ylim = c(0,1),
     xlab = 'Individual dry biomass (mg)', 
     main = 'No vertical drainage')
# rect(xleft = -1000, ybottom = -1000, xright = 15, ytop = 1, col = alpha('blue',0.1), lty = 0)
hist((d$biomass.g[d$lense == 'flat' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('green',0.4), lty = 0, add = T, freq = F)
hist((d$biomass.g[d$lense == 'hummock' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16), 
     col = alpha('blue',0.5), lty = 0, add = T, freq = F)
#legend('topright',legend = c('Hummock','Flat','Hollow'), fill = alpha(c('blue','green','yellow'),0.5), bty = 'n', title = 'Sediment shape')

filter = d$drainage == 'drainage'
hist((d$biomass.g[d$lense == 'hollow' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16), 
     col = alpha('yellow',0.5), lty = 0, freq = F,ylim = c(0,1),
     xlab = 'Individual dry biomass (mg)', 
     main = 'Vertical drainage')
hist((d$biomass.g[d$lense == 'flat' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('green',0.4), lty = 0, add = T, freq = F)
hist((d$biomass.g[d$lense == 'hummock' & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16), 
     col = alpha('blue',0.5), lty = 0, add = T, freq = F)
legend('topright',legend = c('Raised','Flat','Lowered'), fill = alpha(c('blue','green','yellow'),0.5), bty = 'n', title = 'Sediment shape')

filter = d$drainage == 'no drainage'
hist((d$biomass.g[d$inundation.percent == 50 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('blue',0.5), lty = 0, freq = F, ylim = c(0,1), main = '',
     xlab = 'Individual dry biomass (mg)')
# rect(xleft = -1000, ybottom = -1000, xright = 15, ytop = 1, col = alpha('blue',0.1), lty = 0)
hist((d$biomass.g[d$inundation.percent == 35 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('purple',0.5), lty = 0, add = T, freq = F)
hist((d$biomass.g[d$inundation.percent == 20 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('red',0.5), lty = 0, add = T, freq = F)
#legend('topright',legend = c('50 %','35 %','20 %'), fill = alpha(c('blue','purple','red'),0.5), bty = 'n', title = 'Inundation frequency')

filter = d$drainage == 'drainage'
hist((d$biomass.g[d$inundation.percent == 50 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('blue',0.5), lty = 0, freq = F, ylim = c(0,1), main = '',
     xlab = 'Individual dry biomass (mg)')
hist((d$biomass.g[d$inundation.percent == 35 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('purple',0.5), lty = 0, add = T, freq = F)
hist((d$biomass.g[d$inundation.percent == 20 & filter])*1000, breaks = seq(0,16,0.2), xlim = c(0,16),
     col = alpha('red',0.5), lty = 0, add = T, freq = F)
legend('topright',legend = c('50 %','35 %','20 %'), fill = alpha(c('blue','purple','red'),0.5), bty = 'n', title = 'Inundation frequency')
par(mfrow = c(1,1))
# dev.off()

# ---- Statistics ----- #

meanLogBiomass.g = tapply(log(d$biomass.mg), d$pot.ID, mean)
lense = factor(levels(d$lense)[tapply(d$lense, d$pot.ID, unique)], levels = c('hollow','flat','hummock'))
drainage = factor(levels(d$drainage)[tapply(d$drainage, d$pot.ID, unique)], levels = c('no drainage', 'drainage'))
inundFreq = factor(levels(d$inundation.percent)[tapply(d$inundation.percent, d$pot.ID, unique)], levels = c('50','35','20'))

#Full model
m = aov(meanLogBiomass.g ~ lense * drainage * inundFreq)
anova(m)
TukeyHSD(m)

#Reduced model
m = aov(meanLogBiomass.g ~ lense * inundFreq + drainage)
anova(m)
TukeyHSD(m)

#Non-interactive model
m = aov(meanLogBiomass.g ~ lense + drainage + inundFreq)
anova(m)
TukeyHSD(m)


# ----- Report statistics ----- # 

# Reporting average percent comparison values in text (inundation duration):
mean20 = mean(meanLogBiomass.g[inundFreq == '20'])
mean50 = mean(meanLogBiomass.g[inundFreq == '50'])
percDiffInund = (exp(mean20)/exp(mean50) - 1) * 100

deviation50.perc = (abs(exp(meanLogBiomass.g[inundFreq == '50'] - mean50))/exp(mean50) * 100)/sqrt(length(deviation50.perc))
deviation20.perc = abs(exp(meanLogBiomass.g[inundFreq == '20'] - mean20))/exp(mean20) * 100/sqrt(length(deviation20.perc))
meanDeviation.perc = exp(mean(log(c(deviation20.perc, deviation50.perc))))

paste(round(percDiffInund,2),'±', round(meanDeviation.perc,2))

# Reporting average percent comparison values in text (drainage):
meanNoDrain = mean(meanLogBiomass.g[drainage == 'no drainage'])
meanDrain = mean(meanLogBiomass.g[drainage == 'drainage'])
percDiffDrainage = (exp(meanDrain)/exp(meanNoDrain) - 1) * 100

deviationNoDrain.perc = (abs(exp(meanLogBiomass.g[drainage == 'no drainage'] - meanNoDrain))/exp(meanNoDrain) * 100)/sqrt(length(deviationNoDrain.perc))
deviationDrain.perc = (abs(exp(meanLogBiomass.g[drainage == 'drainage'] - meanDrain))/exp(meanDrain) * 100)/sqrt(length(deviationDrain.perc))
meanDeviation.perc = exp(mean(log(c(deviationNoDrain.perc, deviationDrain.perc))))

paste(round(percDiffDrainage,2),'±', round(meanDeviation.perc,2))

# Reporting average percent comparison values in text (sediment shape):
# Reporting average percent comparison values in text (drainage):
meanRaised = mean(meanLogBiomass.g[lense == 'hummock'])
meanFlat = mean(meanLogBiomass.g[lense == 'flat'])
meanLowered = mean(meanLogBiomass.g[lense == 'hollow'])
percDiffRL = (exp(meanRaised)/exp(meanLowered) - 1) * 100
percDiffRF = (exp(meanRaised)/exp(meanFlat) - 1) * 100
percDiffFL = (exp(meanFlat)/exp(meanLowered) - 1) * 100

deviationRaised.perc = (as.numeric(abs(exp(meanLogBiomass.g[lense == 'hummock'] - meanRaised))/exp(meanRaised) * 100))
deviationFlat.perc = (as.numeric(abs(exp(meanLogBiomass.g[lense == 'flat'] - meanFlat))/exp(meanFlat) * 100))
deviationLowered.perc = (as.numeric(abs(exp(meanLogBiomass.g[lense == 'hollow'] - meanLowered))/exp(meanLowered) * 100))
meanDeviationRL.perc = exp(mean(log(c(deviationRaised.perc, deviationLowered.perc))))/sqrt(length(deviationRaised.perc))
meanDeviationRF.perc = exp(mean(log(c(deviationRaised.perc, deviationFlat.perc))))/sqrt(length(deviationRaised.perc))
meanDeviationFL.perc = exp(mean(log(c(deviationFlat.perc, deviationLowered.perc))))/sqrt(length(deviationFlat.perc))

paste(round(percDiffRL,2),'±', round(meanDeviationRL.perc,2))
paste(round(percDiffRF,2),'±', round(meanDeviationRF.perc,2))
paste(round(percDiffFL,2),'±', round(meanDeviationFL.perc,2))


# -- U-shaped interaction
meanR35 = mean(meanLogBiomass.g[inundFreq == '35' & lense == 'hummock'])
meanL35 = mean(meanLogBiomass.g[inundFreq == '35' & lense == 'hollow'])

meanNotR35 = mean(meanLogBiomass.g[inundFreq != '35' & lense == 'hummock'])
meanNotL35 = mean(meanLogBiomass.g[inundFreq != '35' & lense == 'hollow'])

meanR50 = mean(meanLogBiomass.g[inundFreq == '50' & lense == 'hummock'])
meanL50 = mean(meanLogBiomass.g[inundFreq == '50' & lense == 'hollow'])

meanR20 = mean(meanLogBiomass.g[inundFreq == '20' & lense == 'hummock'])
meanL20 = mean(meanLogBiomass.g[inundFreq == '20' & lense == 'hollow'])

meanRL20 = (exp(meanR20)/exp(meanL20) - 1) * 100
meanRL35 = (exp(meanR35)/exp(meanL35) - 1) * 100
meanNotRL35 = (exp(meanNotR35)/exp(meanNotL35) - 1) * 100
meanRL50 = (exp(meanR50)/exp(meanL50) - 1) * 100

deviationRaised.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '50' & lense == 'hummock'] - meanR50))/exp(meanR50) * 100)
deviationLowered.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '50' & lense == 'hollow'] - meanL50))/exp(meanL50) * 100)
meanDeviationRL50.perc = exp(mean(log(c(deviationRaised.perc, deviationLowered.perc))))/sqrt(42)

deviationRaised.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '35' & lense == 'hummock'] - meanR35))/exp(meanR35) * 100)
deviationLowered.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '35' & lense == 'hollow'] - meanL35))/exp(meanL35) * 100)
meanDeviationRL35.perc = exp(mean(log(c(deviationRaised.perc, deviationLowered.perc))))/sqrt(42)

deviationRaised.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '20' & lense == 'hummock'] - meanR20))/exp(meanR20) * 100)
deviationLowered.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq == '20' & lense == 'hollow'] - meanL20))/exp(meanL20) * 100)
meanDeviationRL20.perc = exp(mean(log(c(deviationRaised.perc, deviationLowered.perc))))/sqrt(42)

deviationRaised.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq != '35' & lense == 'hummock'] - meanNotR35))/exp(meanNotR35) * 100)
deviationLowered.perc = as.numeric(abs(exp(meanLogBiomass.g[inundFreq != '35' & lense == 'hollow'] - meanNotL35))/exp(meanNotL35) * 100)
meanDeviationNotRL35.perc = exp(mean(log(c(deviationRaised.perc, deviationLowered.perc))))/sqrt(42)


paste(round(meanRL20,2),'±', round(meanDeviationRL20.perc,2))
paste(round(meanRL35,2),'±', round(meanDeviationRL35.perc,2))
paste(round(meanNotRL35,2),'±', round(meanDeviationNotRL35.perc,2))
paste(round(meanRL50,2),'±', round(meanDeviationRL50.perc,2))


mean50 = mean(meanLogBiomass.g[inundFreq == '50'])
percDiffInund = (exp(meanRL20)/exp(meanRL50) - 1) * 100







# --- log Figure 1 ---- #

par(mfrow = c(2,2))
filter = d$drainage == 'no drainage'
hist(log(d$biomass.g[d$lense == 'hollow' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('yellow',0.5), lty = 0, freq = F,ylim = c(0,1),
     xaxt = 'n',
     xlab = 'Individual dry biomass (mg)', 
     main = 'No vertical drainage')
axis(side = 1, at = log(10^seq(-2,2,1)), labels = 10^seq(-2,2,1))
rect(xleft = -1000, ybottom = -1000, xright = 15, ytop = 1, col = alpha('blue',0.1), lty = 0)
hist(log(d$biomass.g[d$lense == 'flat' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('green',0.4), lty = 0, add = T, freq = F)
hist(log(d$biomass.g[d$lense == 'hummock' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('blue',0.5), lty = 0, add = T, freq = F)
#legend('topright',legend = c('Hummock','Flat','Hollow'), fill = alpha(c('blue','green','yellow'),0.5), bty = 'n', title = 'Sediment shape')

filter = d$drainage == 'drainage'
hist(log(d$biomass.g[d$lense == 'hollow' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('yellow',0.5), lty = 0, freq = F,ylim = c(0,1),
     xaxt = 'n',
     xlab = 'Individual dry biomass (mg)', 
     main = 'No vertical drainage')
axis(side = 1, at = log(10^seq(-2,2,1)), labels = 10^seq(-2,2,1))
hist(log(d$biomass.g[d$lense == 'flat' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('green',0.4), lty = 0, add = T, freq = F)
hist(log(d$biomass.g[d$lense == 'hummock' & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('blue',0.5), lty = 0, add = T, freq = F)
legend('topright',legend = c('Raised','Flat','Lowered'), fill = alpha(c('blue','green','yellow'),0.5), bty = 'n', title = 'Sediment shape', cex = 0.8)

filter = d$drainage == 'no drainage'
hist(log(d$biomass.g[d$inundation.percent == 50 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('blue',0.5), lty = 0, freq = F, ylim = c(0,1), main = '',
     xaxt = 'n',
     xlab = 'Individual dry biomass (mg)')
axis(side = 1, at = log(10^seq(-2,2,1)), labels = 10^seq(-2,2,1))
rect(xleft = -1000, ybottom = -1000, xright = 15, ytop = 1, col = alpha('blue',0.1), lty = 0)
hist(log(d$biomass.g[d$inundation.percent == 35 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('purple',0.5), lty = 0, add = T, freq = F)
hist(log(d$biomass.g[d$inundation.percent == 20 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('red',0.5), lty = 0, add = T, freq = F)
#legend('topright',legend = c('50 %','35 %','20 %'), fill = alpha(c('blue','purple','red'),0.5), bty = 'n', title = 'Inundation frequency')

filter = d$drainage == 'drainage'
hist(log(d$biomass.g[d$inundation.percent == 50 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('blue',0.5), lty = 0, freq = F, ylim = c(0,1), main = '',
     xaxt = 'n',
     xlab = 'Individual dry biomass (mg)')
axis(side = 1, at = log(10^seq(-2,2,1)), labels = 10^seq(-2,2,1))
hist(log(d$biomass.g[d$inundation.percent == 35 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('purple',0.5), lty = 0, add = T, freq = F)
hist(log(d$biomass.g[d$inundation.percent == 20 & filter]*1000), breaks = seq(-5,5,0.1), xlim = c(-5,5), 
     col = alpha('red',0.5), lty = 0, add = T, freq = F)
legend('topright',legend = c('50 %','35 %','20 %'), fill = alpha(c('blue','purple','red'),0.5), bty = 'n', title = 'Inundation frequency', cex = 0.8)
par(mfrow = c(1,1))

